# Funkcja print
#składnia python 2.7: print b albo print b, (nowa linia lub jedna linia), przyjmie też print(b)
#składania python 3.7: print(b)
#help(print)
#przyjmijmy, że pracujemy na pythonie 2.7

#1. Najprostszy Witaj świecie

print("Witaj swiecie")

#2. Komentarze

#3. Podstawowe operatory (+,-,*,/)

#4. Przypisanie, zmienne
a=5
a,b=3,5
a=b=c=12

#5. Podstawowe konwersje typów
int(a)
float(a)
long(a)
str(a)

#6. Więcej operatorów
#szczególne zachowanie dzielenia 
#(można też stosować konwersję)
a=12
b=5
a/b

a=12.0
b=5.0
a/b

#modulo (licznik części ułamkowej po podzieleniu)
a%b

#floor division - dzielenie z pominięciem części ułamkowej w wyniku
a//b

#potęgowanie
a**2

# porównanie
a==b
a!=b
a<>b
a>b
a<b
a>=b
a<=b

# przypisanie z operacją
a+=c #(a=a+c)
a-=c #(a=a-c)
a*=c #(a=a*c)
a/=c #(a=a/c)
a%=c #(a=a%c)
a//=c #(a=a//c)

#7. Listy
#Lista w Python'nie nie wymaga określenia 
#typu danych:
a = ['pies', 'kot', 100, 1234]

#Odwołanie do wartości listy:
a[0]
a[-2]
a[1:3]
a[1:-1]

#Łączenie i generowanie list:
a[:2] + ['mysz', 2*2]
3*a[:3] + ['dzik']

#8. Tablice
#Utworzenie tablicy
A=[
['Jan',80,75,85],
['Julia',75,80,75,85,100],
['Krystyna',80,80,80,90,95]
]
#Pobranie wartości elementu
A[0][0]
#Zapis wartości do elementu
A[0][1] = 156

#9. Operacje na stringach
#konkatenacja
a='Jestem '
b='Janusz'
a+b

#string jako tablica znaków
a[0], a[1]

#metody string (dir(a)), wybrane:
a.count('e') #zlicz wystąpienia
a.__len__() #podaj długość
a.index('e') #podaj indeks pierwszego wystapienia
a.__contains__('e') #prawda, gdy ciąg zawiera znak
a.upper(),a.lower(),a.capitalize()

#formatowanie (a.format()), więcej na: 
https://docs.python.org/3.4/library/string.html#formatspec

#formatowanie operatorem (%s - tekst, %d - liczba całkowita)
"Wynik obliczenia to %f" % 23.345
"Wynik obliczenia to: %.f" % 23.678
"Wynik obliczenia to: %.2f" % 23.678
  #użycie kilku pól
  K = 23
  Z = 4
  "%d jest wieksze od %d" % (K,Z)

#Słowniki (Dictionary) w Pythonie, czyli tablice asocjacyjne
# przechowują elementy powiązane ze sobą na zasadzie klucz:wartość
a={'kot':'puszysty','pies':'wierny',1:'liczba','liczba':123}
#użycie
a['kot']

#zbiory (sets)
a={'kot','pies','mysz',1,2,3}
b={'szczur','koala','mysz',1,5,3}

#przykładowe operacje na zbiorach (można popatrzeć w podpowiedzi składni)
b.intersection(a)
b.difference(a)
b.issubset(a)

#Wypisanie elementów zbioru
a={'kot','pies','mysz',1,2,3}
for element in a:
  print element

#Krotki, są bardzo podobne do list
#podstawowa różnica jest taka, że krotka może być identyfikatorem tablicy asocjacyjnej.
a=(1,2,'mysz','lis')

zbior={(1,2):'element1',(3,'kot'):'element 2'}
#użycie
zbior[(3,'kot')]

#10. Przyjmowanie wartości z konsoli i wydawanie wyniku
a = input("Podaj a: ")
b = input("Podaj b: ")
print(a+b)

#11. Instrukcja warunkowa if
x=input("Podaj liczbe calkowita: ") #x = int(raw_input("Podaj liczbe calkowita: "))
if x<0:
    x=0
    print("Liczba mniejsza od zera, zmieniono na zero.")
elif x==0:
    print('Podano zero')
elif x==1:
    print('Podano jeden')
else:
    print('Liczba jest większa od 1')

#12. Zadanie - Napisz program, który będzie pytał o imię i będzie posiadał słownik imion. Jeżeli podane imię jest w słowniku, pojawi się komunikat "Witaj <imię>, w przeciwnym wypadku komunikat: "Nie znam cię". 

slownik = ["Janusz","Anna","Izydor","Leoncjusz","Kornelia"]
imie = input("Podaj imie: ")
if slownik.__contains__(imie):
    print("Witaj "+imie)
else:
    print("Nie znam cię")

#12a. Zadanie - Wykorzystanie warunku, konwersji, modulo i floor division
# Program zamieniający ułamek niewłaściwy na ułamek właściwy. Przedstawia wynik w postaci ułamka zwykłego.
a=input("Podaj licznik: ")
b=input("Podaj mianownik: ")
if a%b==0:
  print(str(a/b))
else:
  print(str(a//b) + " " +str(a%b)+'/'+str(b))

#Sterowanie wykonaniem
#Pętla While
#Ciąg Fibonacciego - suma poprzedzjących elementów definiuje następny
a,b=0,1
while a<10:
	print(b)
	a,b=b,a+b

#Zmodyfikuj pętlę tak aby można było podać warunek ograniczający (n) z klawiatury
n=input("Podaj n: ")
a,b=0,1
while a<int(n):
	print(b)
	a,b=b,a+b


#Pętla For - iteratorem może być dowolny zbiór wartości
zwierzeta = ['pies','kot','mysz','dzik']
for zwierze in zwierzeta:
        print zwierze,len(zwierze)
		
#funkcja range()
 #zakres od zera
 range(10)

#zakres od-do
range(5,20)

#zakres z krokiem[od:do:krok]
range(10)[2:8:2]
range(10)[::2]
range(10)[::-1]
range(10)[8:2:-1]


#Petla for iterator całkowity range()
for i in range(10):
   print i,
   
#zmodyfikuj pętlę tak, aby  numerowała elementy na liście (iteracja po elementach listy)
lista = ['Janusz','Anna','Krzysztof','Maria','Zenon']
for imie in lista:
	print(str(lista.index(imie)+1)+'.'+imie)

#zmodyfikuj pętlę tak, aby  numerowała elementy na liście (iteracja range())
lista = ['Janusz','Anna','Krzysztof','Maria','Zenon']
for i in range(lista.__len__()):
        print(str(i+1)+'.'+lista[i])	
	
#zmodyfikuj pętlę tak, aby elementy na liście były w posortowane automatycznie kolejności alfaberycznej 
#i ponumerowane od 10 z krokiem 10
lista = ['Janusz','Anna','Krzysztof','Maria','Zenon']
lista.sort()
for i in range(lista.__len__()):
        print(str((i+1)*10)+'.'+lista[i])
	
#(inne) operacje na listach z użyciem pętli for
[f.capitalize() for f in ['ala','adam','kot']]
[f/10 for f in [12,65,78]]
#zakres z krokiem niecałkowitym (generuje listę)
[p*0.1 for p in range(10)]
   
#Pętla for, iterator niecałkowity (wygenerowana, dowolna lista wartości)
for i in [p*0.1 for p in range(10)]:
     print i,
	 
#Zamiana znaku w ciągu tekstowym z użyciem listy
a='janusz'
s=[x for x in a]
s[0]='J'
x=''
a=x.join(s) 
	 

#Przykład z BREAK
#break - przerwie wykonanie pętli i wyjdzie z pętli
szukane_zwierze = 'kot'
zwierzeta = ['pies','szczur','mysz','kot','foka']
for zwierze in zwierzeta:
	if zwierze == szukane_zwierze:
		print('znalazlem zwierze: '+zwierze)
		break
	print zwierze+' to nie '+szukane_zwierze

#Przykład z continue
#continue - przerwie wykonanie pętli i wykona kolejną iterację pętli
szukane_zwierze = 'kot'
zwierzeta = ['pies','szczur','mysz','kot','foka']
for zwierze in zwierzeta:
	if zwierze == szukane_zwierze:
		print('znalazlem zwierze: '+zwierze)
		continue
	print zwierze+' to nie '+szukane_zwierze

#Przeanalizuj przypadki z break i continue, gdy na liście szukane zwierze występuje więcej niż  1 raz.
	
#(Samodzielnie) zmodyfikuj program tak, aby wyświetlał wszystkie zwierzęta komunikując czy znalazł zwierzę czy nie
#wykorzystując else. Co zauważasz? 
szukane_zwierze = 'kot'
zwierzeta = ['pies','szczur','mysz','kot','foka']
for zwierze in zwierzeta:
	if zwierze == szukane_zwierze:
		print('znalazlem zwierze: '+zwierze)
	
	else: print zwierze+' to nie '+szukane_zwierze
	
#(Samodzielnie)	
#Wykonać zadanie z wyszukiwaniem zwierzęcia obsługujące sytuację, gdy nie ma go na liście (dać komunikat np. "nie ma zwierzęcia kot")
szukane_zwierze = 'kot'
zwierzeta = ['pies','szczur','mysz','kot','foka']
znalazlem = False;
for zwierze in zwierzeta:
	if zwierze == szukane_zwierze:
		print('znalazlem zwierze: '+zwierze)
		znalazlem=True
if znalazlem==False:
	print('nie ma zwierzecia: '+szukane_zwierze)

#(Samodzilenie)
#Pętla zagnieżdżona
#Wyswietl elementy tablicy w formie macierzy 
tablica=[
[12,21,23,45],
[34,23,56,34],
[54,34,32,34]
]

for i in range(3):     
   for j in range(4):
      print tablica[i][j],
   print ''

#Zmodyfikuj przykład aby wyświetlały się znaki "|" na poczatku i końcu linii
for i in range(3):   
   print '|',     
   for j in range(4):
      print tablica[i][j],
   print '|'

 #Napisz algorytm dokonujący transpozycji macierzy
tablica=[
[12,21,23,45],
[34,23,56,34],
[54,34,32,34]
]

tab=[[0 for p in range(3)] for p in range(4)]
for i in range(3):
   for j in range(4):
      #print tablica[i][j],
      tab[j][i]=tablica[i][j]     
print tab

##Obsługa wyjątków
#Rozważmy przykład (generuje wyjątek "ValueError")
a = "abc"
int(a)
print a

#Obsługa wyjątku "ValueError"
a = "abc"
try:
  int(a)
  print a
except ValueError:
  print "Zly format"
 
#Wyjątek z komunikatem
a = "abc"
try:
  int(a)
  print a
except ValueError,komunikat:
  print "Nastąpił wyjątek: ",komunikat

#Wyjątek z komunikatem i wykonaniem w przypadku powodzenia
a = "abc"
try:
  int(a)
  print a
except ValueError,komunikat:
  print "Nastąpił wyjątek: ",komunikat
else:
  print("OK")	

#Wyjątek ze wszystkimi mozliwościami
a = "rr"
try:
  int(a)
  print a
except ValueError,komunikat:
  print "Nastąpił wyjątek: ",komunikat
else:
  print("OK")
finally:
   print("Program zakończony")

##Wielokrotne użycie kodu
#Funkcje
#Bez zwracania wartości (procedura)
def suma(a,b):
  print(a+b)

#Zwracająca wartość  (funkcja)
def suma1(a,b):
  return a+b

#wywołanie funkcji
#UWAGA: obie funkcje muszą być w tym samym skrypcie.
suma(12,34)
suma1(23,45)
a=suma1(23,89)
suma(suma1(20,30),50)

#(Samodzielnie) korzystając z algorytmu wyszukiwania zwierzęcia na liście, stwórz funkcję wyszukującą z argumentem wejściowym: zwierze
def szukaj(zwierze):
  szukane_zwierze = zwierze
  zwierzeta = ['pies','szczur','mysz','kot','foka']
  znalazlem = False;
  for zwierze in zwierzeta:
    if zwierze == szukane_zwierze:
      print('znalazlem zwierze: '+zwierze)
      znalazlem=True
  if znalazlem==False:
    print('nie ma zwierzecia: '+szukane_zwierze)


#(samodzielnie) zmień kod funkcji tak, aby zwracała numer pozycji zwierzęcia na liście. 
#W przypadku braku zwierzęcia na liście niech funkcja zwraca wartość -1.
def szukaj(zwierze):
  szukane_zwierze = zwierze
  zwierzeta = ['pies','szczur','mysz','kot','foka','kot']
  znalazlem = False;
  for zwierze in zwierzeta:
    if zwierze == szukane_zwierze:
      znalazlem=True
      return zwierzeta.index(zwierze)
  if znalazlem==False:
    return -1

#Wykorzystanie własnej funkcji, przekazanie parametru
#(samodzielnie) stwórz funkcję ktoryNaLiscie() wykorzystującą funkcję szukaj(). Funkcja ma zwracać komunikat, np.: "kot ma nr 3 na liście".
#W przypadku braku zwierzęcia, komunikat np.: "Na liście nie ma zwierzęcia kot"

def ktoryNaLiscie(zwierze):
  nr = szukaj(zwierze)
  if nr!=-1:
     print zwierze,"ma nr",nr+1, "na liście"
  else:
     print "Na liście nie ma zwierzęcia:",zwierze

#(samodzielnie)
#Stwórz skrypt wykorzystujący funkcję generującą ciąg Fibonacciego do podanej wartości. Skrypt powinien poprosić o wprowadzenie wartości z klawiatury.
def ciagFib(n):
  a,b=0,1
  while a<n:
    print(b)
    a,b=b,a+b
n=input("Podaj liczbę: ")
ciagFib(n)

##Wielokrotne użycie kodu
#klasy i obiekty
#Przykładowa klasa, znaczenie słowa kluczowego self - reprezentacji instancji klasy
class Klasa:
  i=10
  def daji(self):
    return self.i
  def daj10i(self):
    return self.i*10
#wywołanie
k=Klasa()

#Dziedziczenie
class KlasaDruga(Klasa):
   n=5
   def dajn(self):
      return self.n
#wywołanie
k2=KlasaDruga()

#Wielokrotne dziedziczenie
class KlasaTrzecia(KlasaDruga,Klasa):
   x=12
   def dajx(self):
      return self.x
#wywołanie
k3=KlasaTrzecia

#Konstruktor klasy
class Klasa:
  i=10
  def __init__(self,k):
     self.i=k
  def daji(self):
    return self.i
  def daj10i(self):
    return self.i*10
#wywołanie
k=Klasa(12)

#Dziedziczenie z klasy posiadającej zdefiniowany konstruktor
#Proszę utworzyć klasę KlasaDruga(Klasa) dziedziczącą z Klasa (z konstruktorem).
#Proszę zwrócić uwagę, że w tym wypadku konstruktor również został odziedziczony i należy podać dla niego parametr w klasie podrzędnej.
k2=KlasaDruga(12)

#wywołanie metody klasy nadrzędnej w metodzie klasy podrzędnej
#w klasie podrzędnej możemy wywołać dowolną metodę klasy nadrzędnej (również jej konstruktor)
class Klasa:
  i=10
  def __init__(self,k):
     self.i=k
  def daji(self):
    return self.i
  def daj10i(self):
    return self.i*10

class KlasaCzwarta(Klasa):
  def oblicz(self,mnoznik):
    return Klasa.daji(self)*mnoznik

#Funkcje Pythona do sprawdzania przynależności do klasy oraz hierarchii klas
isinstance(k2,KlasaDruga)
issubclass(KlasaDruga,Klasa)

#Widoczność zmiennych, metod i pól
#Chcąc uczynić metodę lub pole "lokalną" należy użyć odpowiedniego sposobu nazewnictwa np.
_zmienna
def _metoda():

#(samodzielnie) Proszę przetestować działanie ukrywania zmiennych i metod w klasach (powinny być niewidoczne w podpowiedziach). Mimo wszystko można je wywoływać, Python nie nakłada restrykcyjnego ograniczenia w tym względzie.

#(samodzielnie) Proszę stworzyć klasę Figura oraz dziedziczące z niej Kolo, Trojkat i Prostokat. Figura posiada pole "kolor". Klasy dziedziczące posiadają metodę pole - liczącą pole figury. Wielkości potrzebne do obliczeń podaje się podczas tworzenia obiektu (np. prostokat). 

#WERSJA 1 (z wywołaniem konstruktora nadklasy)
class Figura:
  kolor=""
  def __init__(self,kolor):
    self.kolor=kolor  

class Prostokat(Figura):
  a=0.0
  b=0.0
  def __init__(self,kolor,a,b):
    Figura.__init__(self,kolor)
    self.a,self.b=a,b
  def pole(self):
    return self.a*self.b

#WERSJA 2 (z przekazaniem parametrów z klasy nadrzędnej)
class Figura:
  kolor=""
  _m=0.0
  _n=0.0
  def __init__(self,kolor,m,n):
    self.kolor=kolor
    self._m=m
    self._n=n

class Prostokat(Figura):
  a=0.0
  b=0.0    
  def pole(self):
    self.a,self.b=self._m,self._n
    return self.a*self.b

##Biblioteki i moduły w PYTHON
#SciPy nie instalowany standardowo w 2.77 i w QGIS, powinien być w 3.7
http://cs231n.github.io/python-numpy-tutorial/
#biblioteka math
import math
#wyświetlenie wszystkich metod i pól biblioteki
dir(math)

#biblioteka numpy
import numpy as np

a = np.array([1, 2,3])
b = np.array([[1,2,3],[4,5,6]])

#Operacje na macierzach (w oparciu o elementy) (przykłady)
np.multiply(a,b)
a*b
np.divide(a,b)
a/b
np.add(a,b)
a+b
np.subtract(a,b)
a-b
np.sqrt(a)
np.cos(a)

#Operacje mnożenia macierzowego
a = np.array([1, 2])
b = np.array([[1,2,3],[4,5,6]])

a.dot(b)

#przykładowe operacje na macierzach
a = np.array([[1,2,3,4], [5,6,7,8], [9,10,11,12]])
b = a[:2, 1:3]

#generowanie zakresu - z krokiem i bez
np.arange(0,10,0.5)

#generowanie macierzy zer
np.zeros((2,3))

#biblioteka matplotlib - wykresy
#Narysuj wykres funkcji sinus
import numpy as np
import matplotlib.pyplot as plt

# oblicz współrzędne x i y na krzywej funkcji sinus
x = np.arange(0, 3 * np.pi, 0.1)
y = np.sin(x)

# Narysuj wykres używając matplotlib
plt.plot(x, y)
plt.show()  # należy wywołać plt.show() aby pojawiła się grafika.

##Obsługa plików
#zapis do pliku ( nadpisanie)
plik_wyjsciowy = open('abc_python.txt','w+')
plik_wyjsciowy.write('Jakiś tekst\r\n')
plik_wyjsciowy.close()

#dopisanie
plik_wyjsciowy = open('abc_python.txt','a+')
plik_wyjsciowy.write('Całkiem inny tekst\r\n')
plik_wyjsciowy.close()

#odczyt z pliku
plik_wejsciowy = open('abc_python.txt','r')
if plik_wejsciowy.mode=='r':
  zawartosc=plik_wejsciowy.read()
  print(zawartosc)

##PYTHON W QGIS
#Podczas pracy z API zaleca się korzystanie z dokumentacji API, gdyż sama znajomość języka Python i umiejętność programowania są w tym przypadku niewystarczające
https://docs.qgis.org/2.18/en/docs/pyqgis_developer_cookbook/
https://qgis.org/api/2.18/

#Akcje - przykład
w QGIS: 
1. Dodać warstwę "admin_countries.shp"
2. Prawym na warstwie -> Właściwości -> Akcje -> Add new action
3. Ustawić akcję jako Python, podać opis, wstawić kod:
print("[%NAME%]")

Po uruchomieniu akcji w konsoli Pythona bedą widoczne nazwy krajów
#Sprawdzić, czy akcja zadziała na innej warstwie (dzialki jeleniogorski.shp) (nie powinna, co to oznacza?).

#Własne skrypty na bazie konsoli (można importować bibliotekę processing: import processing : i mieć wszystkie funkcje geoanalizy dostępne we własnym skrypcie)
#stworzenie i import przykładowego skryptu do QGIS przez konsolę
#Pracujemy z QGIS - konsola Pythona i Edytor zintegrowany z konsolą
1.Stworzyć plik skryptQGIS.py zawierający funkcję np.:
def suma(a,b):
  return(a+b)

2. Umieścić plik w katalogu skryptów QGIS np.:
C:\Users\janusz\.qgis2\python\skrypt.py

3. W konsoli QGIS:
import skryptQGIS as sq
sq.suma(2,5)

##Przydatne metody dostępu do warstw wektorowych
#WCZYTAĆ WARSTWĘ "jeleniogorski.shp" i jeszcze jedną dowolną

#pobranie aktywnej warstwy
warstwa = iface.activeLayer()

#pobranie nazwy warstwy
warstwa.name()

#pobranie warstwy według nazwy
listaWarstw = QgsMapLayerRegistry.instance().mapLayersByName("jeleniogorski")

#pobranie wszystkich warstw
warstwy=[war for war in QgsMapLayerRegistry.instance().mapLayers().values()]
warstwy[0]
warstwy[0].name()

#Pobranie informacji o atrybutach
listaWarstw = QgsMapLayerRegistry.instance().mapLayersByName("jeleniogorski")
#spr. czy lista nie jest pusta
if listaWarstw:
  warstwa = listaWarstw[0] #pobierz tylko jedną (pierwszą na liście)
  for pole in warstwa.pendingFields():
    print pole.name(), pole.typeName()
	
#Selekcja atrybutów - zmiana koloru selekcji
from PyQt4.QtGui import *
iface.mapCanvas().setSelectionColor(QColor('red'))

#Iteracja po atrybutach warstwy (ograniczenie konieczne ze względu na ilość)
warstwa = iface.activeLayer()
obiekty = warstwa.getFeatures()
limit = 10
licz=0
for obiekt in obiekty:
  if licz<=limit:
    print(obiekt.id())
    licz=licz+1
  else:
    break
	
#Modyfikacja przykładu, wyświetlanie informacji o geometrii
warstwa = iface.activeLayer()
obiekty = warstwa.getFeatures()
limit = 10
licz=0
for obiekt in obiekty:
  if licz<=limit:
    geom = obiekt.geometry()
    if geom.type() == QGis.Polygon:
      x = geom.asPolygon()
      numPts = 0
      for ring in x:
          numPts += len(ring)
      print "Polygon. Ilosc pierscieni: %d, ilosc wierzcholkow: %d" % (len(x), numPts)

    licz=licz+1
  else:
    break
	
#Wyświetlanie wartości atrybutów
warstwa = iface.activeLayer()
obiekty = warstwa.getFeatures()
limit = 10
licz=0
for obiekt in obiekty:
  if licz<=limit:
    atrybuty = obiekt.attributes()
    print atrybuty ####
    licz=licz+1
  else:
    break	
	
#Odczytane w powyższy sposób atrybuty są listą, można więc odwołać się do wartości o konkretnym indeksie:
print atrybuty[1] #

#Można też odwołać się bezpośrednio przez obiekt gis:
print obiekt['TERYT'] #	
#lub
print obiekt[0] #

#Iterowanie po wybranych obiektach (zbiór selekcji)
#Sposób 1
selekcja = warstwa.selectedFeatures()
print len(selekcja)
for obiekt in selekcja:
    # operacje na wybranych obiektach np.
    print obiekt.id()
	
#Sposób 2 - wykorzystanie biblioteki processing
import processing
obiekty= processing.features(warstwa)
for obiekt in obiekty:
    # Operacje na obiektach np.
    print obiekt.id()

#więcej przykładów odnośnie warstw wektorowych można znaleźć na:
https://docs.qgis.org/2.18/en/docs/pyqgis_developer_cookbook/vector.html

